﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;

public partial class Admin_NeiRong_GeShou_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    private new int ID;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改歌手", "网站后台", "修改歌手", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        ID = Convert.ToInt32(Request.QueryString["ID"]);
        if (this.IsPostBack)
            保存();
        else
            初始化();
    }

    private void 保存()
    {
        访问.验证权限("19");
        String 歌手名称 = GeShou_YueDuiMingChen.Text;
        String 歌手类型;
        if (GeShouLeiXing_0.Checked)
            歌手类型 = "男歌手";
        else if (GeShouLeiXing_1.Checked)
            歌手类型 = "女歌手";
        else
            歌手类型 = "乐队组合";
        String 歌手简介 = GeShouJianJie.Text;
        String 歌手地区;
        if (GeShouDiQu_0.Checked)
            歌手地区 = "大陆";
        else if (GeShouDiQu_1.Checked)
            歌手地区 = "港台";
        else if (GeShouDiQi_2.Checked)
            歌手地区 = "欧美";
        else if (GeShouDiQu_3.Checked)
            歌手地区 = "日韩";
        else
            歌手地区 = "其它";

        if (歌手名称.Length < 1 || 歌手名称.Length > 20)
            throw new Exception("歌手名称的长度只能是1-20之间。");
        if (歌手简介.Length < 1 || 歌手简介.Length > 4000)
            throw new Exception("歌手简介的长度只能是1-4000之间。");

        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_音乐_歌手] SET " +
            "[歌手/乐队名称]=@歌手_乐队名称," +
            "[歌手地区]=@歌手地区," +
            "[歌手类型]=@歌手类型," +
            "[歌手简介]=@歌手简介 WHERE [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@歌手_乐队名称", SqlDbType.NVarChar).Value = 歌手名称;
        语句.Parameters.Add("@歌手地区", SqlDbType.NVarChar).Value = 歌手地区;
        语句.Parameters.Add("@歌手类型", SqlDbType.NVarChar).Value = 歌手类型;
        语句.Parameters.Add("@歌手简介", SqlDbType.NVarChar).Value = 歌手简介;
        语句.ExecuteNonQuery();
        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改歌手[" + 歌手名称 + "]。", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }

    private void 初始化()
    {
        Hashtable 歌手 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "内容_音乐_歌手] WHERE [ID]=" + ID, 访问.连接));

        if (歌手 == null)
            throw new Exception("歌手不存在");

        GeShou_YueDuiMingChen.Text = 歌手["歌手/乐队名称"].ToString();
        GeShouTuPian.ImageUrl = 歌手["歌手图片"].ToString();
        switch (Convert.ToString(歌手["歌手类型"]))
        {
            case "男歌手":
                GeShouLeiXing_0.Checked = true;
                break;
            case "女歌手":
                GeShouLeiXing_1.Checked = true;
                break;
            default:
                GeShouLeiXing_2.Checked = true;
                break;
        }
        switch (Convert.ToString(歌手["歌手地区"]))
        {
            case "大陆":
                GeShouDiQu_0.Checked = true;
                break;
            case "港台":
                GeShouDiQu_1.Checked = true;
                break;
            case "欧美":
                GeShouDiQi_2.Checked = true;
                break;
            case "日韩":
                GeShouDiQu_3.Checked = true;
                break;
            default:
                GeShouDiQu_4.Checked = true;
                break;
        }
        GeShouJianJie.Text = Convert.ToString(歌手["歌手简介"]);
    }
}
